/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import jnr.unixsocket.UnixSocketAddress;
import net.impactdev.impactor.relocations.com.mongodb.ServerAddress;
import net.impactdev.impactor.relocations.com.mongodb.annotations.Immutable;
import net.impactdev.impactor.relocations.com.mongodb.assertions.Assertions;

@Immutable
public final class UnixServerAddress
extends ServerAddress {
    private static final long serialVersionUID = 154466643544866543L;

    public UnixServerAddress(String path) {
        super(Assertions.notNull("The path cannot be null", path));
        Assertions.isTrueArgument("The path must end in .sock", path.endsWith(".sock"));
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        throw new UnsupportedOperationException("Cannot return a InetSocketAddress from a UnixServerAddress");
    }

    public SocketAddress getUnixSocketAddress() {
        return new UnixSocketAddress(this.getHost());
    }

    @Override
    public String toString() {
        return this.getHost();
    }
}

